.TH sane 7 "03 Jan 2020" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane

.SH NAME
sane \- Scanner Access Now Easy: API for accessing scanners

.SH DESCRIPTION
.B SANE
is an application programming interface (API) that provides standardized
access to any raster image scanner hardware. The standardized interface makes
it possible to write just one driver for each scanner device instead of one
driver for each scanner and application.

While
.B SANE
is primarily targeted at a UNIX environment, the standard has been carefully
designed to make it possible to implement the API on virtually any hardware or
operating system.
.PP
This manual page provides a summary of the information available about
.BR SANE .
.PP
If you have trouble getting your scanner detected, read the PROBLEMS section.

.SH TERMINOLOGY

An application that uses the
.B SANE
interface is called a
.B SANE frontend.
A driver that implements the
.B SANE
interface is called a
.B SANE backend.
A
.B meta backend
provides some means to manage one or more other backends.


.SH "SOFTWARE PACKAGES"
The package
.B sane\-backends
contains backends, documentation, networking support, and the
command line frontend
.BR scanimage (1).
The frontends
.BR xscanimage (1),
.BR xcam (1),
and
.BR scanadf (1)
are included in the package
.BR sane\-frontends .
Both packages can be downloaded from the
.B SANE
homepage
.RI ( http://www.sane\-project.org/ ).
Information about other frontends and backends can also be found on the
.B SANE
homepage.

.SH "GENERAL INFORMATION"
The following sections provide short descriptions and links to more
information about several aspects of
.BR SANE .
A name with a number in parenthesis (e.g.
.BR sane\-dll (5))
points to a manual page. In this case
.I man\ 5\ sane\-dll
will display the page. Entries like
.I @DOCDIR@/README
are references to text files that were copied to the
.B SANE
documentation directory
.RI ( @DOCDIR@/ )
during installation. Everything else is a URL to a resource on the web.

.TP 2
.B SANE homepage
Information on all aspects of SANE including a tutorial and a link to the SANE FAQ
can be found on the SANE homepage:
.IR http://www.sane\-project.org/ .
.TP
.B SANE device lists
The
.B SANE
device lists contain information about the status of
.B SANE
support for a specific device. If your scanner is not listed there (either
supported or unsupported), please contact us. See section HOW CAN YOU HELP
SANE for details. There are lists for specific releases of SANE, for the
current development version and a search engine:
.IR http://www.sane\-project.org/sane\-supported\-devices.html .
The lists are also installed on your system at
.IR @DOCDIR@/ .
.TP
.B SANE mailing list
There is a mailing list for the purpose of discussing the SANE standard and its
implementations: sane\-devel.  Despite its name, the list is not only intended
for developers, but also for users. There are also some more lists for special
topics. However, for users, sane\-devel is the right list. How to subscribe and
unsubscribe:
.IR http://www.sane\-project.org/mailing\-lists.html .
.TP
.B SANE IRC channel
The IRC (Internet Relay Chat) channel #sane can be found on the Freenode
network (irc.libera.chat). It's for discussing
.B SANE
problems, talking about development and general
.B SANE
related chatting. Before asking for help, please read the other documentation
mentioned in this manual page. The channel's topic is also used for
announcements of problems with SANE infrastructure (mailing lists, web server,
etc.).
.TP
.B Compiling and installing SANE
Look at
.I  @DOCDIR@/README
and the os-dependent README files for information about compiling and
installing
.B SANE.
.TP
.B SCSI configuration
For information about various systems and SCSI controllers see
.BR sane\-scsi (5).
.TP
.B USB configuration
For information about USB configuration see
.BR sane\-usb (5).

.SH "FRONTENDS AND MISCELLANEOUS PROGRAMS"
.TP 2
.B scanimage
Command-line frontend. See
.BR scanimage (1).
.TP
.B saned
.B SANE
network daemon that allows remote clients to access image acquisition devices
available on the local host. See
.BR saned (8).
.TP
.B sane\-find\-scanner
Command-line tool to find SCSI and USB scanners and determine their UNIX
device files. See
.BR sane\-find\-scanner (1).
.PP
Also, have a look at the
.B sane\-frontends
package (which includes
.BR xscanimage (1),
.BR xcam (1),
and
.BR scanadf (1))
and the frontend information page at
.IR http://www.sane\-project.org/sane\-frontends.html .

.SH "BACKENDS FOR SCANNERS"
.TP 2
.B abaton
Supports Abaton flatbed scanners such as the Scan 300/GS (8bit,
256 levels of gray) and the Scan 300/S (black and white, untested). See
.BR sane\-abaton (5)
for details.
.TP
.B agfafocus
Supports AGFA Focus scanners and the Siemens S9036 (untested).
See
.BR sane\-agfafocus (5)
for details.
.TP
.B apple
Supports Apple flatbed scanners including the following scanners:
AppleScanner, OneScanner and ColorOneScanner. See
.BR sane\-apple (5)
for details.
.TP
.B artec
Supports several Artec/Ultima SCSI flatbed scanners as
well as the BlackWidow BW4800SP and the Plustek 19200S. See
.BR sane\-artec (5)
for details.
.TP
.B artec_eplus48u
Supports the Artec E+ 48U scanner and re-badged
models like Tevion MD 9693, Medion MD 9693, Medion MD 9705 and Trust Easy
Webscan 19200. See
.BR sane\-artec_eplus48u (5)
for details.
.TP
.B as6e
Supports the Artec AS6E parallel port interface scanner. See
.BR sane\-as6e (5)
for details.
.TP
.B avision
Supports several Avision based scanners including the
original Avision scanners (like AV 630, AV 620, ...) as well as the HP
ScanJet 53xx and 74xx series, Fujitsu ScanPartner, some Mitsubishi and
Minolta film-scanners.
See
.BR sane\-avision (5)
for details.
.TP
.B bh
Supports Bell+Howell Copiscan II series document scanners. See
.BR sane\-bh (5)
for details.
.TP
.B canon
Supports the CanoScan 300, CanoScan 600, and CanoScan
2700F SCSI flatbed scanners. See
.BR sane\-canon (5)
for details.
.TP
.B canon630u
Supports the CanoScan 630u and 636u USB scanners.  See
.BR sane\-canon630u (5)
for details.
.TP
.B canon_dr
Supports the Canon DR-Series ADF SCSI and USB scanners. See
.BR sane\-canon_dr (5)
for details.
.TP
.B canon_lide70
Supports the CanoScan LiDE 70 and 600 USB scanners. See
.BR sane\-canon_lide70 (5)
for details.
.TP
.B canon_pp
Supports the CanoScan FB330P, FB630P, N340P and N640P parallel port
scanners.  See
.BR sane\-canon_pp (5)
for details.
.TP
.B cardscan
Support for Corex Cardscan USB scanners. See
.BR sane\-cardscan (5)
for details.
.TP
.B coolscan coolscan2 coolscan3
Supports Nikon Coolscan film-scanners. See
.BR sane\-coolscan (5),
.BR sane\-coolscan2 (5)
and
.BR sane\-coolscan3 (5)
for details.
.TP
.B epjitsu
Supports Epson-based Fujitsu USB scanners. See
.BR sane\-epjitsu (5)
for details.
.TP
.B epson
Old driver for Epson SCSI, parallel port and USB flatbed scanners. See
.BR sane\-epson (5)
for details but try
.BR epson2
first.
.TP
.B epson2
Newer driver for Epson SCSI, parallel port, network and USB flatbed
scanners (try this before
.BR epson
which is outdated). See
.BR sane\-epson2 (5)
for details.
.TP
.B escl
Supports scanners through the eSCL protocol. See
.BR sane\-escl (5)
for details.
.TP
.B fujitsu
Supports most Fujitsu SCSI and USB, flatbed and adf scanners. See
.BR sane\-fujitsu (5)
for details.
.TP
.B genesys
Supports several scanners based on the Genesys Logic
GL646, GL841, GL843, GL847 and GL124 chips like the
Medion 6471 and Hewlett-Packard 2300c.
See
.BR sane\-genesys (5)
for details.
.TP
.B gt68xx
Supports scanners based on the Grandtech
GT-6801 and GT-6816 chips like the Artec Ultima 2000
and several Mustek BearPaw CU and TA models.
.br
Some Genius,
Lexmark, Medion, Packard Bell, Plustek, and Trust scanners
are also supported. See
.BR sane\-gt68xx (5)
for details.
.TP
.B hp
Supports Hewlett-Packard ScanJet scanners which
utilize SCL (Scanner Control Language by HP). See
.BR sane\-hp (5)
for details.
.TP
.B hpsj5s
Supports the Hewlett-Packard ScanJet 5S scanner. See
.BR sane\-hpsj5s (5)
for details.
.TP
.B hp3500
Supports the Hewlett-Packard ScanJet 3500 series. See
.BR sane\-hp3500 (5)
for details.
.TP
.B hp3900
Supports the Hewlett-Packard ScanJet 3900 series. See
.BR sane\-hp3900 (5)
for details.
.TP
.B hp4200
Supports the Hewlett-Packard ScanJet 4200 series. See
.BR sane\-hp4200 (5)
for details.
.TP
.B hp5400
Supports the Hewlett-Packard ScanJet 54XXC series. See
.BR sane\-hp5400 (5)
for details.
.TP
.B hpljm1005
Supports the Hewlett-Packard LaserJet M1005 scanner. See
.BR sane\-hpljm1005 (5)
for details.
.TP
.B hs2p
Supports the Ricoh IS450 family of SCSI scanners. See
.BR sane\-hs2p (5)
for details.
.TP
.B ibm
Supports some IBM and Ricoh SCSI scanners. See
.BR sane\-ibm (5)
for details.
.TP
.B kodak
Supports some large Kodak scanners. See
.BR sane\-kodak (5)
for details.
.TP
.B kodakaio
Supports Kodak AiO printer/scanners. See
.BR sane\-kodakaio (5)
for details.
.TP
.B kvs1025
Supports Panasonic KV-S102xC scanners. See
.BR sane\-kvs1025 (5)
for details.
.TP
.B leo
Supports the LEO S3 and the Across FS-1130, which is a re-badged
LEO FS-1130 scanner. See
.BR sane\-leo (5)
for details.
.TP
.B lexmark
Supports the Lexmark X1100 series of USB scanners. See
.BR sane\-lexmark (5)
for details.
.TP
.B lexmark_x2600
Supports the Lexmark X2600 series of USB scanners. See
.BR sane\-lexmark_x2600 (5)
for details.
.TP
.B ma1509
Supports the Mustek BearPaw 1200F USB flatbed scanner. See
.BR sane\-ma1509 (5)
for details.
.TP
.B magicolor
Supports the KONICA MINOLTA magicolor 1690MF multi-function printer/scanner/fax. See
.BR sane\-magicolor (5)
for details.
.TP
.B matsushita
Supports some Panasonic KVSS high speed scanners. See
.BR sane\-matsushita (5)
for details.
.TP
.B microtek
Supports "second generation" Microtek scanners with SCSI-1 command set. See
.BR sane\-microtek (5)
for details.
.TP
.B microtek2
Supports some Microtek scanners with a SCSI-2 command set. See
.BR sane\-microtek2 (5)
for details.
.TP
.B mustek
Supports most Mustek SCSI flatbed scanners including the
Paragon and ScanExpress series and the 600 II N and 600 II EP (non-SCSI). Some
Trust scanners are also supported. See
.BR sane\-mustek (5)
for details.
.TP
.B mustek_pp
Supports Mustek parallel port flatbed scanners. See
.BR sane\-mustek_pp (5)
for details.
.TP
.B mustek_usb
Supports some Mustek ScanExpress USB flatbed scanners. See
.BR sane\-mustek_usb (5)
for details.
.TP
.B mustek_usb2
Supports scanners using the SQ113 chipset like the Mustek BearPaw 2448 TA Pro
USB flatbed scanner. See
.BR sane\-mustek_usb2 (5)
for details.
.TP
.B nec
Supports the NEC PC-IN500/4C SCSI scanner. See
.BR sane\-nec (5)
for details.
.TP
.B niash
Supports the Agfa Snapscan Touch and the HP ScanJet 3300c,
3400c, and 4300c USB flatbed scanners. See
.BR sane\-niash (5)
for details.
.TP
.B p5
Supports the Primax PagePartner. See
.BR sane\-p5 (5)
for details.
.TP
.B pie
Supports Pacific Image Electronics (PIE) and Devcom
SCSI flatbed scanners. See
.BR sane\-pie (5)
for details.
.TP
.B pixma
Supports Canon PIXMA MP series (multi-function devices),
Canon imageCLASS series (laser devices), Canon MAXIFY series and some Canon
CanoScan series. See
.BR sane\-pixma (5)
for details.
.TP
.B plustek
Supports USB flatbed scanners that use the National
Semiconductor LM983[1/2/3] chipset aka Merlin. Scanners using this LM983x chips
include some models from Plustek, KYE/Genius, Hewlett-Packard, Mustek, Umax,
Epson, and Canon. See
.BR sane\-plustek (5)
for details.
.TP
.B plustek_pp
Supports Plustek parallel port flatbed scanners using the Plustek ASIC P96001,
P96003, P98001 and P98003, which includes some
models from Plustek, KYE/Genius, Primax. See
.BR sane\-plustek_pp (5)
for details.
.TP
.B ricoh
Supports the Ricoh flatbed scanners IS50 and IS60. See
.BR sane\-ricoh (5)
for details.
.TP
.B ricoh2
Supports the Ricoh flatbed scanners: SG-3100SNw, SP-100SU, and SP-111SU. See
.BR sane\-ricoh2 (5)
for details.
.TP
.B s9036
Supports Siemens 9036 flatbed scanners. See
.BR sane\-s9036 (5)
for details.
.TP
.B sceptre
Supports the Sceptre S1200 flatbed scanner. See
.BR sane\-sceptre (5)
for details.
.TP
.B sharp
Supports Sharp SCSI scanners. See
.BR sane\-sharp (5)
for details.
.TP
.B sm3600
Supports the Microtek ScanMaker 3600 USB scanner. See
.BR sane\-sm3600 (5)
for details.
.TP
.B sm3840
Supports the Microtek ScanMaker 3840 USB scanner.  See
.BR sane\-sm3840 (5)
for details.
.TP
.B snapscan
Supports AGFA SnapScan flatbed scanners including some which are
rebadged to other brands. See
.BR sane\-snapscan (5)
for details.
.TP
.B sp15c
Supports the Fujitsu FCPA ScanPartner 15C flatbed scanner. See
.BR sane\-sp15c (5)
for details.
.TP
.B st400
Supports the Siemens ST400 and ST800. See
.BR sane\-st400 (5)
for details.
.TP
.B tamarack
Supports Tamarack Artiscan flatbed scanners. See
.BR sane\-tamarack (5)
for details.
.TP
.B teco1 teco2 teco3
Supports some TECO scanners, usually sold under the Relisys, Trust,
Primax, Piotech, Dextra names. See
.BR sane\-teco1 (5),
.BR sane\-teco2 (5)
and
.BR sane\-teco3 (5)
for details.
.TP
.B u12
Supports USB flatbed scanners based on Plustek's ASIC 98003
(parallel-port ASIC) and a GeneSys Logics' USB-parport bridge chip like the
Plustek OpticPro U(T)12. See
.BR sane\-u12 (5)
for details.
.TP
.B umax
Supports UMAX-SCSI-scanners and some Linotype Hell SCSI-scanners. See
.BR sane\-umax (5)
for details.
.TP
.B umax_pp
Supports Umax parallel port flatbed scanners and the HP 3200C. See
.BR sane\-umax_pp (5)
for details.
.TP
.B umax1200u
Supports the UMAX Astra 1220U (USB) flatbed scanner
(and also the UMAX Astra 2000U, sort of). See
.BR sane\-umax1220u (5)
for details.
.TP
.B xerox_mfp
Supports multiple Samsung-based Samsung, Xerox, and Dell
scanners. See
.BR sane\-xerox_mfp (5)
for details.
.PP
Also, have a look at the backend information page at
.I http://www.sane\-project.org/sane\-supported\-devices.html
and the list of projects in
.IR @DOCDIR@/PROJECTS .

.SH "BACKENDS FOR DIGITAL CAMERAS"
.TP 2
.B dc210
Supports the Kodak DC210 Digital Camera. See
.BR sane\-dc210 (5).
.TP
.B dc240
Supports the Kodak DC240 Digital Camera. See
.BR dc240 (5).
.TP
.B dc25
Supports Kodak DC20/DC25 Digital Cameras. See
.BR dc25 (5).
.TP
.B dmc
Supports the Polaroid Digital Microscope Camera. See
.BR dmc (5).
.TP
.B gphoto2
Supports digital cameras supported by the gphoto2 library package.  (See
.I http://www.gphoto.org
for more information and a list of supported cameras.)  Gphoto2 supports over
140 different camera models.  However, please note that more development and
testing is needed before all of these cameras will be supported by
.B SANE
backend.  See
.BR gphoto2 (5).
.TP
.B qcam
Supports Connectix QuickCam cameras. See
.BR qcam (5).
.TP
.B stv680
Supports webcams with a stv680 chip. See
.BR stv680 (5)
for details.
.PP
Also, have a look at the backend information page at
.I http://www.sane\-project.org/sane\-supported\-devices.html
and the list of projects in
.IR @DOCDIR@/PROJECTS .

.SH "MISCELLANEOUS BACKENDS"
.TP 2
.B dll
Implements a
.B SANE
backend that provides access to an arbitrary number of other
.B SANE
backends by dynamic loading. See
.BR sane\-dll (5).
.TP
.B net
The
.B SANE
network daemon
.BR saned (8)
provides access to scanners located on different
computers in connection with the
.BR sane\-net (5)
backend. See
.BR saned (8).
.TP
.B pnm
PNM image reader pseudo-backend. The purpose of this backend is primarily to
aid in debugging of
.B SANE
frontends. See
.BR sane\-pnm (5).
.TP
.B pint
Supports scanners that use the
.B PINT
(Pint Is Not Twain) device driver.  The
.B PINT
driver is being actively developed on the OpenBSD platform, and has been
ported to a few other *NIX-like operating systems. See
.BR sane\-pint (5).
.TP
.B test
Tests frontends and the
.B SANE
installation.  It provides test pictures and various test options. See
.BR sane\-test (5).
.TP
.B v4l
Provides generic access to video cameras and similar equipment
using the
.B V4L
(Video for Linux) API. See
.BR sane\-v4l (5) .
.PP
Also, have a look at the backend information page at
.I http://www.sane\-project.org/sane\-supported\-devices.html
and the list of projects in
.IR @DOCDIR@/PROJECTS .

.SH "CHANGING THE TOP-LEVEL BACKEND"
By default, all
.B SANE
backends (drivers) are loaded dynamically by the
.B sane\-dll
meta backend. If you have any questions about the dynamic loading, read
.BR sane\-dll (5).
.B SANE
frontends can also be linked to other backends directly by copying or linking a
backend to
.B libsane.so
in
.IR @LIBDIR@ .
.PP

.SH "DEVELOPER'S DOCUMENTATION"
It's not hard to write a
.B SANE
backend. It can take some time, however. You should have basic knowledge of C
and enough patience to work through the documentation and find out how your
scanner works. Appended is a list of some documents that help to write backends
and frontends.
.PP
The
.B SANE
standard defines the application programming interface (API) that is used to
communicate between frontends and backends. It can be found at
.I http://sane\-project.gitlab.io/standard/ .
.PP
There is some more information for programmers in
.IR @DOCDIR@/backend\-writing.txt .
Most of the internal
.B SANE
routines
.RB ( sanei )
are documented using doxygen:
.IR http://www.sane\-project.org/sanei/ .
Before a new backend or frontend project is started, have a look at
.I @DOCDIR@/PROJECTS
for projects that are planned or not yet included into the
.B SANE
distribution and at our bug-tracking system:
.IR http://www.http://www.sane\-project.org/bugs.html .
.PP
There are some links on how to find out about the protocol of a scanner:
.IR http://www.meier\-geinitz.de/sane/misc/develop.html .

.PP
If you start writing a backend or frontend or any other part of
.BR SANE,
please contact the sane\-devel mailing list for coordination so
that work is not duplicated.

.SH "FILES"
.TP
.I @CONFIGDIR@/*.conf
The backend configuration files.
.TP
.I @LIBDIR@/libsane\-*.a
The static libraries implementing the backends.
.TP
.I @LIBDIR@/libsane\-*.so
The shared libraries implementing the backends (present on systems that
support dynamic loading).
.TP
.I @DOCDIR@/*
.B SANE
documentation: The READMEs, text files for backends etc.

.SH "PROBLEMS"
If your device isn't found but you know that it is supported, make
sure that it is detected by your operating system. For SCSI and USB scanners,
use the
.BR sane\-find\-scanner (1)
utility.
It prints one line for each scanner it has detected and some comments (#).
If
.BR sane\-find\-scanner (1)
finds your scanner only as root but not as normal user, the permissions for
the device files are not adjusted correctly. If the scanner isn't found at all,
the operating system hasn't detected it and may need some help. Depending on
the type of your scanner, read
.BR sane\-usb (5)
or
.BR sane\-scsi (5).
If your scanner (or other device) is not connected over the SCSI bus or USB,
read the backend's manual page for details on how to set it up.
.PP

Is your scanner detected by the operating system but not by
.BR SANE ?
Try
.IR "scanimage\ \-L" .
If the scanner is not found, check that the backend's name is mentioned in
.IR @CONFIGDIR@/dll.conf .
Some backends are commented out by default. Remove the comment sign for your
backend in this case. Also some backends aren't compiled at all if one of their
prerequisites are missing. Examples include dc210, dc240, canon_pp, hpsj5s,
gphoto2, pint, qcam, v4l, net, sm3600, snapscan, pnm. If you need one of these
backends and it isn't available, read the build instructions in the
.B README
file and the individual manual pages of the backends.
.PP

Another reason for not being detected by
.I scanimage\ \-L
may be a missing or incorrect configuration in the backend's configuration
file. While
.B SANE
tries to automatically find most scanners, some can't be setup correctly
without the intervention of the administrator. Also on some operating systems
auto-detection may not work. Check the backend's manual page for details.
.PP
If your scanner is still not found, try
setting the various environment variables that are available to assist in
debugging.  The environment variables are documented in the
relevant manual pages.  For example, to get the maximum amount of debug
information when testing a Mustek SCSI scanner, set environment variables
.BR SANE_DEBUG_DLL ", " SANE_DEBUG_MUSTEK ", and " SANE_DEBUG_SANEI_SCSI
to 128 and then invoke
.IR scanimage\ \-L .
The
.B SANE_DEBUG_DLL
messages tell if the
.BR sane\-mustek (5)
backend was found and loaded at all. The
.B SANE_DEBUG_MUSTEK
messages explain what the backend is
doing while the
.B SANE_DEBUG_SCSI
debugging shows the low level handling. If you can't find
out what's going on by checking the messages carefully, contact the sane\-devel
mailing list for help (see REPORTING BUGS below).
.PP
Now that your scanner is found by
.IR "scanimage\ \-L" ,
try to do a scan:
.IR "scanimage\ >image.pnm" .
This command starts a scan for the default scanner with default settings. All
the available options are listed by running
.IR "scanimage\ \-\-help" .
If scanning aborts with an error message, turn on debugging as mentioned
above. Maybe the configuration file needs some tuning, e.g. to setup the path
to a firmware that is needed by some scanners. See the backend's manual page
for details. If you can't find out what's wrong, contact sane\-devel.
.PP
To check that the
.B SANE
libraries are installed correctly you can use the test backend, even if you
don't have a scanner or other
.B SANE
device:
.IP
scanimage \-d test \-T
.PP
You should get a list of PASSed tests. You can do the same with your backend
by changing "test" to your backend's name.
.PP
So now scanning with
.B scanimage (1)
works and you want to use one of the graphical frontends like
.BR xsane (1) ,
.BR xscanimage (1) ", or"
.BR quiteinsane (1)
but those frontends don't detect your scanner? One reason may be that you
installed two versions of
.BR SANE .
E.g. the version that was installed by your distribution in
.I /usr
and one you installed from source in
.IR /usr/local/ .
Make sure that only one version is installed. Another possible reason is, that
your system's dynamic loader can't find the
.B SANE
libraries. For Linux, make sure that
.I /etc/ld.so.conf
contains
.I /usr/local/lib
and does
.B not
contain
.IR /usr/local/lib/sane .
See also the documentation of the frontends.
.PP

.SH "HOW CAN YOU HELP SANE"
We appreciate any help we can get. Please have a look at our web page about
contributing to
.BR SANE :
.I http://www.sane\-project.org/contrib.html
.PP

.SH "CONTACT"
For reporting bugs or requesting new features, please use our bug-tracking
system:
.IR http://www.sane\-project.org/bugs.html .
You can also contact the author of your backend directly. Usually the email
address can be found in the
.I @DOCDIR@/AUTHORS
file or the backend's manpage. For general discussion about SANE, please use
the
.B SANE
mailing list sane\-devel (see
.I http://www.sane\-project.org/mailing\-lists.html
for details).
.PP

.SH "SEE ALSO"
.BR saned (8),
.BR sane\-find\-scanner (1),
.BR scanimage (1),
.BR sane\-abaton (5),
.BR sane\-agfafocus (5),
.BR sane\-apple (5),
.BR sane\-artec (5),
.BR sane\-artec_eplus48u (5),
.BR sane\-as6e (5),
.BR sane\-avision (5),
.BR sane\-bh (5),
.BR sane\-canon (5),
.BR sane\-canon630u (5),
.BR sane\-canon_dr (5),
.BR sane\-canon_pp (5),
.BR sane\-cardscan (5),
.BR sane\-coolscan (5),
.BR sane\-coolscan2 (5),
.BR sane\-coolscan3 (5),
.BR sane\-dc210 (5),
.BR sane\-dc240 (5),
.BR sane\-dc25 (5),
.BR sane\-dll (5),
.BR sane\-dmc (5),
.BR sane\-epson (5),
.BR sane\-epson2 (5),
.BR sane\-escl (5),
.BR sane\-fujitsu (5),
.BR sane\-genesys (5),
.BR sane\-gphoto2 (5),
.BR sane\-gt68xx (5),
.BR sane\-hp (5),
.BR sane\-hpsj5s (5),
.BR sane\-hp3500 (5),
.BR sane\-hp3900 (5),
.BR sane\-hp4200 (5),
.BR sane\-hp5400 (5),
.BR sane\-hpljm1005 (5),
.BR sane\-ibm (5),
.BR sane\-kodak (5),
.BR sane\-leo (5),
.BR sane\-lexmark (5),
.BR sane\-lexmark_x2600 (5),
.BR sane\-ma1509 (5),
.BR sane\-matsushita (5),
.BR sane\-microtek2 (5),
.BR sane\-microtek (5),
.BR sane\-mustek (5),
.BR sane\-mustek_pp (5),
.BR sane\-mustek_usb (5),
.BR sane\-mustek_usb2 (5),
.BR sane\-nec (5),
.BR sane\-net (5),
.BR sane\-niash (5),
.BR sane\-pie (5),
.BR sane\-pint (5),
.BR sane\-plustek (5),
.BR sane\-plustek_pp (5),
.BR sane\-pnm (5),
.BR sane\-qcam (5),
.BR sane\-ricoh (5),
.BR sane\-ricoh2 (5),
.BR sane\-s9036 (5),
.BR sane\-sceptre (5),
.BR sane\-scsi (5),
.BR sane\-sharp (5),
.BR sane\-sm3600 (5),
.BR sane\-sm3840 (5),
.BR sane\-snapscan (5),
.BR sane\-sp15c (5),
.BR sane\-st400 (5),
.BR sane\-stv680 (5),
.BR sane\-tamarack (5),
.BR sane\-teco1 (5),
.BR sane\-teco2 (5),
.BR sane\-teco3 (5),
.BR sane\-test (5),
.BR sane\-u12 (5),
.BR sane\-umax1220u (5),
.BR sane\-umax (5),
.BR sane\-umax_pp (5),
.BR sane\-usb (5),
.BR sane\-v4l (5),
.BR sane\-xerox_mfp (5)

.SH AUTHOR
David Mosberger-Tang and many many more (see
.I @DOCDIR@/AUTHORS
for details).  This man page was written by Henning Meier-Geinitz. Quite a lot
of text was taken from the
.B SANE
standard, several man pages, and README files.
