# google-cloud-core

This library contains shared types, such as error classes, for the google-cloud
project. Please see the [GitHub
repository](https://github.com/googleapis/google-cloud-ruby) for more
information about the individual google-cloud gems.

- [google-cloud-core API documentation](https://googleapis.dev/ruby/google-cloud-core/latest)

## Supported Ruby Versions

This library is supported on Ruby 3.0+.

Google provides official support for Ruby versions that are actively supported
by Ruby Core—that is, Ruby versions that are either in normal maintenance or
in security maintenance, and not end of life. Older versions of Ruby _may_
still work, but are unsupported and not recommended. See
https://www.ruby-lang.org/en/downloads/branches/ for details about the Ruby
support schedule.

## Versioning

This library follows [Semantic Versioning](http://semver.org/).

It is currently in major version zero (0.y.z), which means that anything may
change at any time and the public API should not be considered stable.

## Contributing

Contributions to this library are always welcome and highly encouraged.

See the [Contributing
Guide](https://googleapis.dev/ruby/google-cloud-core/latest/file.CONTRIBUTING.html)
for more information on how to get started.

Please note that this project is released with a Contributor Code of Conduct. By
participating in this project you agree to abide by its terms. See [Code of
Conduct](https://googleapis.dev/ruby/google-cloud-core/latest/file.CODE_OF_CONDUCT.html)
for more information.

## License

This library is licensed under Apache 2.0. Full license text is available in
[LICENSE](https://googleapis.dev/ruby/google-cloud-core/latest/file.LICENSE.html).

## Support

Please report bugs
[on Github](https://github.com/googleapis/google-cloud-ruby/issues).
You can also ask questions about the client or APIs on StackOverflow.
