% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Statement.R
\name{freeStatement}
\alias{freeStatement}
\alias{freeStatement,Statement-method}
\title{Free memory used by a librdf statement}
\usage{
freeStatement(.Object)

\S4method{freeStatement}{Statement}(.Object)
}
\arguments{
\item{.Object}{a Statement object}
}
\description{
Free memory used by a librdf statement
}
\details{
After this method is called, the Statement object is no longer usable and should
be deleted  \code{"rm(statement)"} and a new object created. This method frees
all resources for the statement, as well as each node in the statement.
}
\examples{
world <- new("World")
stmt <- new("Statement", world, subject="http://www.example.com/myevent",
                                predicate="http://example.com/occurredAt",
                                object="Tue Feb 17 14:05:13 PST 2015")
# At this point, some operations would be performed with the Statement.
# See '?redland' for a complete example.
# When the Statement object is no longer needed, the resources it had allocated can be freed.
freeStatement(stmt)                                
rm(stmt)
}
