% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/labelManhattan.R
\name{labelManhattan}
\alias{labelManhattan}
\title{Annotate Manhattan or Miami Plot}
\usage{
labelManhattan(
  chr,
  pos,
  name,
  gwas,
  gwasChrLab = "chr",
  gwasPosLab = "pos",
  gwasPLab = "p",
  gwasZLab = "NULL",
  chrmaxpos,
  textPos = 4,
  angle = 0,
  miamiBottom = FALSE
)
}
\arguments{
\item{chr}{A vector of chromosomes for the markers to be labelled.}

\item{pos}{A vector of positions on the chromosome for the markers to be labelled. These must correspond to markers in the GWAS dataset used to make the manhattan plot.}

\item{name}{A vector of labels to be added next to the points specified by \env{chr} and \env{pos}.}

\item{gwas}{The same GWAS dataset used to plot the existing Manhattan or Miami plot to be annotated.}

\item{gwasChrLab}{The name of the column in \env{gwas} containing chromosome number. Defaults to \samp{"chr"}.}

\item{gwasPosLab}{The name of the column in \env{gwas} containing position. Defaults to \samp{"pos"}.}

\item{gwasPLab}{The name of the column in \env{gwas} containing p-values. Defaults to \samp{"p"}.}

\item{gwasZLab}{The name of the column in \env{gwas} containing z-values. Defaults to \samp{"NULL"}.}

\item{chrmaxpos}{Data frame containing x coordinates for chromosome start positions, generated by \code{\link{labelManhattan}}.}

\item{textPos}{An integer or vector dictating where the label should be plotted relative to each point. Good for avoiding overlapping labels. Provide an integer to plot all points in the same relative position or use a vector to specify position for each label. Passed to the \option{pos} option of \code{\link[graphics:text]{graphics::text}}. Defaults to \samp{4}.}

\item{angle}{An integer or vector dictating the plot angle of the label for each point. rovide an integer to plot all points in the same relative position or use a vector to specify position for each label.Passed to the \option{srt} option of \code{\link[graphics:text]{graphics::text}}. Defaults to \samp{0}.}

\item{miamiBottom}{If \samp{TRUE}, labels will be plotted on the lower region of a Miami plot. If \samp{FALSE}, labels will be plotted on the upper region. Defaults to \samp{FALSE}.}
}
\value{
Adds annotation to existing Manhattan or Miami plot
}
\description{
Annotate Manhattan or Miami Plot
}
\details{
Add labels beside specified points on a Manhattan or Miami plot. Ideal for adding locus names to peaks. Currently only designed to work with \code{\link{miamiplot2}}.
}
\note{
Extended to handle extreme P values.
}
\examples{
\dontrun{
labelManhattan(c(4,5,11,19),c(9994215,16717922,45538760,51699256),
               c("GENE1","GENE2","GENE3","GENE4"),
               gwas1,chrmaxpos=chrmaxpos)
labelManhattan(geneLabels$chr,geneLabel$pos,geneLabel$geneName,gwas1,chrmaxpos=chrmaxpos)
}
}
\author{
Jonathan Marten
}
\keyword{GWAS}
\keyword{Manhattan}
\keyword{Miami}
\keyword{annotation}
