/*
 * Decompiled with CFR 0.152.
 */
package usbsid;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.logging.Logger;
import usbsid.Cmd;
import usbsid.Config;
import usbsid.IUSBSID;
import usbsid.USBSIDDevice;

public class USBSID
extends USBSIDDevice
implements IUSBSID {
    private static Logger logger = null;
    private final byte ZERO = 0;
    private volatile boolean run_thread = false;
    private volatile byte[] ring_buffer;
    private volatile int ring_read;
    private volatile int ring_write;
    private final int min_ring_diff = 16;
    private final int default_ring_diff = 64;
    private final int default_ring_diffwin = 64;
    private final int default_ring_size = 256;
    private final int default_ring_sizewin = 8192;
    private static int diff_size;
    private static int ring_size;
    private byte[] thread_buffer = new byte[64];
    private byte buffer_pos = 1;
    private volatile boolean flush_buffer = false;
    private static boolean clk_retrieved;
    private static int cpufrequency;
    private long start_time = System.nanoTime();
    private long last_time;
    private Thread USBSID_Thread = new Thread(new Runnable(){

        @Override
        public void run() {
            try {
                logger.info("[USBSID] Thread started");
                while (USBSID.this.run_thread) {
                    if (USBSID.this.flush_buffer && USBSID.this.buffer_pos >= 5) {
                        USBSID.this.USBSID_flushbuffer();
                    }
                    if (USBSID.this.ring_read == USBSID.this.ring_write || USBSID.this.diff() <= diff_size) continue;
                    USBSID.this.USBSID_fillbuffer();
                }
                logger.info("[USBSID] Thread stopped");
            }
            catch (Exception E) {
                E.printStackTrace();
            }
        }
    });

    private void timeSync() {
        this.last_time = System.nanoTime() - this.start_time;
    }

    private void RingBuffer(int size) {
        this.ring_write = 0;
        this.ring_read = 0;
        this.ring_buffer = new byte[size];
    }

    private void put(byte item) {
        this.ring_buffer[this.ring_write] = item;
        this.ring_write = (this.ring_write + 1) % this.ring_buffer.length;
    }

    private byte get() {
        byte item = this.ring_buffer[this.ring_read];
        this.ring_read = (this.ring_read + 1) % this.ring_buffer.length;
        return item;
    }

    private boolean higher() {
        return this.ring_read < this.ring_write;
    }

    private int diff() {
        int d = this.higher() ? this.ring_read - this.ring_write : this.ring_write - this.ring_read;
        return d < 0 ? d * -1 : d;
    }

    private void USBSID_flushbuffer() throws Exception {
        try {
            this.thread_buffer[0] = (byte)(Cmd.CYCLED_WRITE.get() << 6 | this.buffer_pos - 1);
            byte[] out_buffer = (byte[])this.thread_buffer.clone();
            USBSID.asyncWrite(out_buffer);
            Arrays.fill(this.thread_buffer, (byte)0);
            this.flush_buffer = false;
            this.buffer_pos = 1;
        }
        catch (Exception E) {
            logger.severe("[USBSID] Unhandled exception occured: " + String.valueOf(E));
            throw E;
        }
    }

    private void USBSID_fillbuffer() throws Exception {
        try {
            byte by = this.buffer_pos;
            this.buffer_pos = (byte)(by + 1);
            this.thread_buffer[by] = this.get();
            byte by2 = this.buffer_pos;
            this.buffer_pos = (byte)(by2 + 1);
            this.thread_buffer[by2] = this.get();
            byte by3 = this.buffer_pos;
            this.buffer_pos = (byte)(by3 + 1);
            this.thread_buffer[by3] = this.get();
            byte by4 = this.buffer_pos;
            this.buffer_pos = (byte)(by4 + 1);
            this.thread_buffer[by4] = this.get();
            if (this.buffer_pos == 61 || this.flush_buffer) {
                this.thread_buffer[0] = (byte)(Cmd.CYCLED_WRITE.get() << 6 | this.buffer_pos - 1);
                this.flush_buffer = false;
                this.buffer_pos = 1;
                byte[] write_buffer = (byte[])this.thread_buffer.clone();
                USBSID.asyncWrite(write_buffer);
                Arrays.fill(this.thread_buffer, (byte)0);
            }
        }
        catch (Exception E) {
            logger.severe("[USBSID] Unhandled exception occured: " + String.valueOf(E));
            throw E;
        }
    }

    @Override
    public int USBSID_init(Integer ... vars) {
        if (device != null && USBSID.isOpen()) {
            logger.warning("[USBSID] Device is already open!");
            this.flush_buffer = true;
            return -1;
        }
        USBSID.open_USBSID();
        if (USBSID.isOpen()) {
            logger.info("[USBSID] USBSID-Pico opened");
            this.ring_write = 0;
            this.ring_read = 0;
            if (vars.length > 0) {
                Integer rs = vars[0];
                int n = ring_size = rs >= 256 && rs <= 65535 ? rs : 256;
            }
            if (vars.length > 1) {
                Integer ds = vars[1];
                diff_size = ds >= 16 ? ds : 64;
            }
            this.RingBuffer(ring_size);
            logger.info(MessageFormat.format("[USBSID] Ring buffer size {0} with mininum head->tail distance {1}", ring_size, diff_size));
            this.run_thread = true;
            this.USBSID_Thread.setDaemon(true);
            this.USBSID_Thread.start();
            this.timeSync();
            return 0;
        }
        return -1;
    }

    @Override
    public int USBSID_init() {
        if (USBSID.isWinblows()) {
            ring_size = 8192;
            diff_size = 64;
        } else {
            ring_size = 256;
            diff_size = 64;
        }
        return this.USBSID_init(ring_size, diff_size);
    }

    @Override
    public int USBSID_init(String driver, int ringsize, int diffsize) {
        USBSID.setdriver_USBSID(driver);
        return this.USBSID_init(ringsize, diffsize);
    }

    @Override
    public void USBSID_exit() {
        try {
            if (device == null || !USBSID.isOpen()) {
                logger.warning("[USBSID] Device is not open!");
                return;
            }
            this.USBSID_setflush();
            this.ring_write = 0;
            this.ring_read = 0;
            this.run_thread = false;
            this.USBSID_Thread.join();
            logger.info("[USBSID] Thread joined");
            USBSID.close_USBSID();
            logger.info("[USBSID] USBSID-Pico closed");
            return;
        }
        catch (InterruptedException | NumberFormatException E) {
            logger.severe("[USBSID] Exception occured: " + E.getMessage() + String.valueOf(E.getCause()));
            E.printStackTrace();
            return;
        }
    }

    @Override
    public void USBSID_clkdwrite(byte addr, byte data, short cycles) {
        try {
            byte[] writebuffer = new byte[5];
            byte cycles_hi = (byte)(cycles >> 8 & 0xFFFFFFFF);
            byte cycles_lo = (byte)(cycles & 0xFFFFFFFF);
            writebuffer[0] = (byte)(Cmd.CYCLED_WRITE.get() << 6);
            writebuffer[1] = addr;
            writebuffer[2] = data;
            writebuffer[3] = cycles_hi;
            writebuffer[4] = cycles_lo;
            USBSID.asyncWrite(writebuffer);
        }
        catch (Exception E) {
            logger.severe("[USBSID] Unhandled exception occured: " + String.valueOf(E));
            E.printStackTrace();
            return;
        }
    }

    @Override
    public void USBSID_writeclkdbuffer(byte addr, byte data, short cycles) {
        byte cycles_hi = (byte)(cycles >> 8 & 0xFFFFFFFF);
        byte cycles_lo = (byte)(cycles & 0xFFFFFFFF);
        this.put(addr);
        this.put(data);
        this.put(cycles_hi);
        this.put(cycles_lo);
    }

    @Override
    public void USBSID_setflush() {
        try {
            this.flush_buffer = true;
            this.timeSync();
        }
        catch (Exception E) {
            logger.severe("[USBSID] Unhandled exception occured: " + String.valueOf(E));
            E.printStackTrace();
            return;
        }
    }

    @Override
    public void USBSID_reset(byte volume) {
        try {
            if (device == null || !USBSID.isOpen()) {
                logger.warning("[USBSID] Device is not open!");
                return;
            }
            USBSID.sendCommand(Cmd.RESET_SID.get(), (byte)0);
            if (volume == 0) {
                USBSID.sendCommand(Cmd.MUTE.get(), new Byte[0]);
            }
            if (volume > 0) {
                USBSID.sendCommand(Cmd.UNMUTE.get(), new Byte[0]);
            }
            this.flush_buffer = true;
            this.timeSync();
        }
        catch (Exception E) {
            logger.severe("[USBSID] Exception occured: " + String.valueOf(E));
            E.printStackTrace();
            return;
        }
    }

    @Override
    public void USBSID_setclock(double CpuClock) {
        try {
            if (!clk_retrieved || cpufrequency == Config.CLK.DEFAULT.get()) {
                byte[] clock = USBSID.rwConfigCommand(Config.Cfg.GET_CLOCK.get(), 1, new Byte[0]);
                cpufrequency = Config.CLK.IDclk(clock[0]);
                clk_retrieved = true;
            }
            if ((int)CpuClock != cpufrequency) {
                cpufrequency = (int)CpuClock;
                logger.info(MessageFormat.format("[USBSID] Clock change requested: {0}", cpufrequency));
                byte freq = 0;
                freq = (byte)Config.CLK.clkID(Config.CLK.getCLK(cpufrequency));
                USBSID.sendConfigCommand(Config.Cfg.SET_CLOCK.get(), freq);
            } else {
                logger.info(MessageFormat.format("[USBSID] Clock not changed, already at: {0}", cpufrequency));
                this.flush_buffer = true;
                this.timeSync();
            }
        }
        catch (Exception E) {
            logger.severe("[USBSID] Unhandled exception occured: " + String.valueOf(E));
            E.printStackTrace();
            return;
        }
    }

    @Override
    public int USBSID_setstereo(int stereo) {
        try {
            USBSID.sendConfigCommand(Config.Cfg.SET_AUDIO.get(), (byte)stereo);
            return stereo;
        }
        catch (Exception E) {
            logger.severe("[USBSID] Unhandled exception occured: " + String.valueOf(E));
            E.printStackTrace();
            return -1;
        }
    }

    @Override
    public byte[] USBSID_getsocketconfig() {
        byte[] socketcfg = null;
        try {
            socketcfg = USBSID.rwConfigCommand(Config.Cfg.READ_SOCKETCFG.get(), 10, new Byte[0]);
        }
        catch (Exception E) {
            logger.severe("[USBSID] Unhandled exception occured: " + String.valueOf(E));
            E.printStackTrace();
        }
        return socketcfg;
    }

    @Override
    public int[] USBSID_parsesocketconfig(byte[] socketcfg) {
        int socketone_numsids;
        assert (socketcfg[0] == Config.Cfg.READ_SOCKETCFG.get());
        assert (socketcfg[1] == 127);
        assert (socketcfg[9] == -1);
        int socketone_en = socketcfg[2] >> 4;
        int socketone_dual = socketcfg[2] & 0xF;
        int socketone_chiptype = socketcfg[3] >> 4;
        int socketone_clonetype = socketcfg[3] & 0xF;
        int socketone_sidone = socketcfg[4] >> 4;
        int socketone_sidtwo = socketcfg[4] & 0xF;
        int sockettwo_en = socketcfg[5] >> 4;
        int sockettwo_dual = socketcfg[5] & 0xF;
        int sockettwo_chiptype = socketcfg[6] >> 4;
        int sockettwo_clonetype = socketcfg[6] & 0xF;
        int sockettwo_sidone = socketcfg[7] >> 4;
        int sockettwo_sidtwo = socketcfg[7] & 0xF;
        int mirrored = socketcfg[8] & 0xF;
        int n = socketone_en == 1 ? (socketone_dual == 1 ? 2 : 1) : (socketone_numsids = 0);
        int sockettwo_numsids = sockettwo_en == 1 ? (sockettwo_dual == 1 ? 2 : 1) : 0;
        int numsids = socketone_numsids + sockettwo_numsids;
        int[] parsed = new int[]{socketone_en, socketone_dual, socketone_chiptype, socketone_clonetype, socketone_sidone, socketone_sidtwo, sockettwo_en, sockettwo_dual, sockettwo_chiptype, sockettwo_clonetype, sockettwo_sidone, sockettwo_sidtwo, socketone_numsids, sockettwo_numsids, numsids, mirrored};
        return parsed;
    }

    @Override
    public int USBSID_getsocketsidtype(int socket, int sidno, byte[] socketcfg) {
        assert (socketcfg[0] == Config.Cfg.READ_SOCKETCFG.get());
        assert (socketcfg[1] == 127);
        assert (socketcfg[9] == -1);
        int socketone_sidone = socketcfg[4] >> 4;
        int socketone_sidtwo = socketcfg[4] & 0xF;
        int sockettwo_sidone = socketcfg[7] >> 4;
        int sockettwo_sidtwo = socketcfg[7] & 0xF;
        switch (socket) {
            case 1: {
                return sidno == 1 ? socketone_sidone : socketone_sidtwo;
            }
            case 2: {
                return sidno == 1 ? sockettwo_sidone : sockettwo_sidtwo;
            }
        }
        return 0;
    }

    @Override
    public int USBSID_sidtypebysidno(int sidno, byte[] socketcfg) {
        int[] parsedcfg = this.USBSID_parsesocketconfig(socketcfg);
        int socketone_en = parsedcfg[0];
        int socketone_sidone = parsedcfg[4];
        int socketone_sidtwo = parsedcfg[5];
        int sockettwo_en = parsedcfg[6];
        int sockettwo_sidone = parsedcfg[10];
        int sockettwo_sidtwo = parsedcfg[11];
        int socketone_numsids = parsedcfg[12];
        int sockettwo_numsids = parsedcfg[13];
        int numsids = parsedcfg[14];
        int[][] configs = new int[][]{{socketone_sidone}, {sockettwo_sidone}, {socketone_sidone, sockettwo_sidone}, {socketone_sidone, socketone_sidtwo}, {sockettwo_sidone, sockettwo_sidtwo}, {socketone_sidone, socketone_sidtwo, sockettwo_sidone}, {socketone_sidone, sockettwo_sidone, sockettwo_sidtwo}, {socketone_sidone, socketone_sidtwo, sockettwo_sidone, sockettwo_sidtwo}};
        int[] sidtypes = null;
        switch (numsids) {
            case 1: {
                sidtypes = socketone_en == 1 ? configs[0] : (int[])(sockettwo_en == 1 ? configs[1] : null);
                break;
            }
            case 2: {
                sidtypes = socketone_en == 1 && socketone_numsids == 1 && sockettwo_en == 1 && sockettwo_numsids == 1 ? configs[2] : (socketone_en == 1 && socketone_numsids == 2 ? configs[3] : (sockettwo_en == 1 && sockettwo_numsids == 2 ? configs[4] : null));
                break;
            }
            case 3: {
                sidtypes = socketone_en == 1 && socketone_numsids == 2 ? configs[5] : (sockettwo_en == 1 && sockettwo_numsids == 2 ? configs[6] : null);
                break;
            }
            case 4: {
                sidtypes = configs[7];
                break;
            }
            default: {
                sidtypes = null;
            }
        }
        return sidtypes[sidno];
    }

    @Override
    public int USBSID_getnumsids() {
        byte numsids = 0;
        try {
            byte[] r = USBSID.rwConfigCommand(Config.Cfg.READ_NUMSIDS.get(), 1, new Byte[0]);
            numsids = r[0];
        }
        catch (Exception E) {
            logger.severe("[USBSID] Unhandled exception occured: " + String.valueOf(E));
            E.printStackTrace();
        }
        return numsids;
    }

    @Override
    public String USBSID_getpcbversion() {
        String pcbversion = "0.0";
        try {
            byte[] result = USBSID.rwConfigCommand(Config.Cfg.US_PCB_VERSION.get(), 64, new Byte[0]);
            byte length = result[1];
            byte[] bytes = Arrays.copyOfRange(result, 2, 2 + length);
            pcbversion = new String(bytes);
        }
        catch (Exception E) {
            logger.severe("[USBSID] Unhandled exception occured: " + String.valueOf(E));
            E.printStackTrace();
        }
        return pcbversion;
    }

    @Override
    public String USBSID_getfwversion() {
        String fwversion = "v0.0.0-ALPHA.19700101";
        try {
            byte[] result = USBSID.rwConfigCommand(Config.Cfg.USBSID_VERSION.get(), 64, new Byte[0]);
            byte length = result[1];
            byte[] bytes = Arrays.copyOfRange(result, 2, 2 + length);
            fwversion = new String(bytes);
        }
        catch (Exception E) {
            logger.severe("[USBSID] Unhandled exception occured: " + String.valueOf(E));
            E.printStackTrace();
        }
        return fwversion;
    }

    @Override
    public void USBSID_delay(short cycles) {
        long cpu_cycle_in_ns = (long)((float)(1.0 / (double)cpufrequency) * 1.0E9f);
        long now = System.nanoTime() - this.start_time;
        long duration = (long)cycles * cpu_cycle_in_ns;
        long target_time = this.last_time + duration;
        long target_delta = target_time - now;
        this.nsleep(target_delta);
        this.last_time = target_time;
    }

    private void nsleep(long delayNs) {
        long start = System.nanoTime();
        long end = 0L;
        while (start + delayNs >= (end = System.nanoTime())) {
        }
    }

    static {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT] [USBSID] [%4$s] %5$s %n");
        logger = Logger.getLogger(USBSIDDevice.class.getName());
        diff_size = 0;
        ring_size = 0;
        clk_retrieved = false;
        cpufrequency = Config.CLK.DEFAULT.get();
    }
}

