; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=armv7-linux-gnueabi -relocation-model=static < %s \
; RUN:   | FileCheck %s --check-prefix=STATIC
; RUN: llc -mtriple=armv7-linux-gnueabi -relocation-model=pic < %s \
; RUN:   | FileCheck %s --check-prefix=PIC

@preemptable_var = dso_preemptable global i32 42
define ptr @get_preemptable_var() nounwind {
; STATIC-LABEL: get_preemptable_var:
; STATIC:       @ %bb.0:
; STATIC-NEXT:    movw r0, :lower16:preemptable_var
; STATIC-NEXT:    movt r0, :upper16:preemptable_var
; STATIC-NEXT:    bx lr
;
; PIC-LABEL: get_preemptable_var:
; PIC:       @ %bb.0:
; PIC-NEXT:    ldr r0, .LCPI0_0
; PIC-NEXT:  .LPC0_0:
; PIC-NEXT:    ldr r0, [pc, r0]
; PIC-NEXT:    bx lr
; PIC-NEXT:    .p2align 2
; PIC-NEXT:  @ %bb.1:
; PIC-NEXT:  .LCPI0_0:
; PIC-NEXT:  .Ltmp0:
; PIC-NEXT:    .long preemptable_var(GOT_PREL)-(.LPC0_0+8-.Ltmp0)
  ret ptr @preemptable_var
}

@dsolocal_var = dso_local global i32 42
define ptr @get_dsolocal_var() nounwind {
; STATIC-LABEL: get_dsolocal_var:
; STATIC:       @ %bb.0:
; STATIC-NEXT:    movw r0, :lower16:dsolocal_var
; STATIC-NEXT:    movt r0, :upper16:dsolocal_var
; STATIC-NEXT:    bx lr
;
; PIC-LABEL: get_dsolocal_var:
; PIC:       @ %bb.0:
; PIC-NEXT:    ldr r0, .LCPI1_0
; PIC-NEXT:  .LPC1_0:
; PIC-NEXT:    add r0, pc, r0
; PIC-NEXT:    bx lr
; PIC-NEXT:    .p2align 2
; PIC-NEXT:  @ %bb.1:
; PIC-NEXT:  .LCPI1_0:
; PIC-NEXT:    .long .Ldsolocal_var$local-(.LPC1_0+8)
  ret ptr @dsolocal_var
}

@weak_dsolocal_var = weak dso_local global i32 42
define ptr @get_weak_dsolocal_var() nounwind {
; STATIC-LABEL: get_weak_dsolocal_var:
; STATIC:       @ %bb.0:
; STATIC-NEXT:    movw r0, :lower16:weak_dsolocal_var
; STATIC-NEXT:    movt r0, :upper16:weak_dsolocal_var
; STATIC-NEXT:    bx lr
;
; PIC-LABEL: get_weak_dsolocal_var:
; PIC:       @ %bb.0:
; PIC-NEXT:    ldr r0, .LCPI2_0
; PIC-NEXT:  .LPC2_0:
; PIC-NEXT:    add r0, pc, r0
; PIC-NEXT:    bx lr
; PIC-NEXT:    .p2align 2
; PIC-NEXT:  @ %bb.1:
; PIC-NEXT:  .LCPI2_0:
; PIC-NEXT:    .long weak_dsolocal_var-(.LPC2_0+8)
  ret ptr @weak_dsolocal_var
}

@hidden_var = hidden global i32 42
define ptr @get_hidden_var() nounwind {
; STATIC-LABEL: get_hidden_var:
; STATIC:       @ %bb.0:
; STATIC-NEXT:    movw r0, :lower16:hidden_var
; STATIC-NEXT:    movt r0, :upper16:hidden_var
; STATIC-NEXT:    bx lr
;
; PIC-LABEL: get_hidden_var:
; PIC:       @ %bb.0:
; PIC-NEXT:    ldr r0, .LCPI3_0
; PIC-NEXT:  .LPC3_0:
; PIC-NEXT:    add r0, pc, r0
; PIC-NEXT:    bx lr
; PIC-NEXT:    .p2align 2
; PIC-NEXT:  @ %bb.1:
; PIC-NEXT:  .LCPI3_0:
; PIC-NEXT:    .long hidden_var-(.LPC3_0+8)
  ret ptr @hidden_var
}

@protected_var = protected global i32 42
define ptr @get_protected_var() nounwind {
; STATIC-LABEL: get_protected_var:
; STATIC:       @ %bb.0:
; STATIC-NEXT:    movw r0, :lower16:protected_var
; STATIC-NEXT:    movt r0, :upper16:protected_var
; STATIC-NEXT:    bx lr
;
; PIC-LABEL: get_protected_var:
; PIC:       @ %bb.0:
; PIC-NEXT:    ldr r0, .LCPI4_0
; PIC-NEXT:  .LPC4_0:
; PIC-NEXT:    add r0, pc, r0
; PIC-NEXT:    bx lr
; PIC-NEXT:    .p2align 2
; PIC-NEXT:  @ %bb.1:
; PIC-NEXT:  .LCPI4_0:
; PIC-NEXT:    .long protected_var-(.LPC4_0+8)
  ret ptr @protected_var
}

define dso_preemptable ptr @preemptable_func() nounwind {
; STATIC-LABEL: preemptable_func:
; STATIC:       @ %bb.0:
; STATIC-NEXT:    movw r0, :lower16:preemptable_func
; STATIC-NEXT:    movt r0, :upper16:preemptable_func
; STATIC-NEXT:    bx lr
;
; PIC-LABEL: preemptable_func:
; PIC:       @ %bb.0:
; PIC-NEXT:    ldr r0, .LCPI5_0
; PIC-NEXT:  .LPC5_0:
; PIC-NEXT:    ldr r0, [pc, r0]
; PIC-NEXT:    bx lr
; PIC-NEXT:    .p2align 2
; PIC-NEXT:  @ %bb.1:
; PIC-NEXT:  .LCPI5_0:
; PIC-NEXT:  .Ltmp1:
; PIC-NEXT:    .long preemptable_func(GOT_PREL)-(.LPC5_0+8-.Ltmp1)
  ret ptr @preemptable_func
}

define dso_local ptr @dsolocal_func() nounwind {
; STATIC-LABEL: dsolocal_func:
; STATIC:       @ %bb.0:
; STATIC-NEXT:    movw r0, :lower16:dsolocal_func
; STATIC-NEXT:    movt r0, :upper16:dsolocal_func
; STATIC-NEXT:    bx lr
;
; PIC-LABEL: dsolocal_func:
; PIC:       @ %bb.0:
; PIC-NEXT:    ldr r0, .LCPI6_0
; PIC-NEXT:  .LPC6_0:
; PIC-NEXT:    add r0, pc, r0
; PIC-NEXT:    bx lr
; PIC-NEXT:    .p2align 2
; PIC-NEXT:  @ %bb.1:
; PIC-NEXT:  .LCPI6_0:
; PIC-NEXT:    .long .Ldsolocal_func$local-(.LPC6_0+8)
  ret ptr @dsolocal_func
}

define weak dso_local ptr @weak_dsolocal_func() nounwind {
; STATIC-LABEL: weak_dsolocal_func:
; STATIC:       @ %bb.0:
; STATIC-NEXT:    movw r0, :lower16:weak_dsolocal_func
; STATIC-NEXT:    movt r0, :upper16:weak_dsolocal_func
; STATIC-NEXT:    bx lr
;
; PIC-LABEL: weak_dsolocal_func:
; PIC:       @ %bb.0:
; PIC-NEXT:    ldr r0, .LCPI7_0
; PIC-NEXT:  .LPC7_0:
; PIC-NEXT:    add r0, pc, r0
; PIC-NEXT:    bx lr
; PIC-NEXT:    .p2align 2
; PIC-NEXT:  @ %bb.1:
; PIC-NEXT:  .LCPI7_0:
; PIC-NEXT:    .long weak_dsolocal_func-(.LPC7_0+8)
  ret ptr @weak_dsolocal_func
}

;; call .Ldsolocal_func$local either resolves to a constant at assembly time
;; or produces a relocation referencing a non-preemptible local symbol.
define dso_local void @call_dsolocal_func() nounwind {
; STATIC-LABEL: call_dsolocal_func:
; STATIC:       @ %bb.0:
; STATIC-NEXT:    .save {r11, lr}
; STATIC-NEXT:    push {r11, lr}
; STATIC-NEXT:    bl dsolocal_func
; STATIC-NEXT:    pop {r11, pc}
;
; PIC-LABEL: call_dsolocal_func:
; PIC:       @ %bb.0:
; PIC-NEXT:    .save {r11, lr}
; PIC-NEXT:    push {r11, lr}
; PIC-NEXT:    bl .Ldsolocal_func$local
; PIC-NEXT:    pop {r11, pc}
  call ptr @dsolocal_func()
  ret void
}
