/* SPDX-License-Identifier: GPL-2.0-only OR GPL-3.0-only */
/* Copyright (c) 2024-2025 Brett Sheffield <bacs@librecast.net> */

%option noinput
%option nounput
%{
#include <agent.h>
#include <state.h>
#include <stdio.h>
#include <string.h>
#include <y.tab.h>
%}

%%
auth_key			return AUTH_KEY;
channel				return CHANNEL;
chroot				return CHROOT;
command				return COMMAND;
cmd				return COMMAND;
enable				return ENABLE;
debug				return TOK_DEBUG;
directory			return DIRECTORY;
disable				return NOENABLE;
noenable			return NOENABLE;
join				return JOIN;
logfile				return LOGFILE;
nojoin				return NOJOIN;
onstart				return ONSTART;
reload				return RELOAD;
restart				return RESTART;
seed				return SEED;
status				return STATUS;
status-command			return STATUS_COMMAND;
stderr				return STDERR;
stdin				return STDIN;
stdout				return STDOUT;
try				return TRY;
\"[^"]*["] {
        yylval.sval = yytext + 1;
        if (yylval.sval[yyleng - 2] != '"')
                fprintf(stderr, "double quoted string not closed\n");
        else
                yylval.sval[yyleng-2] = 0;
        return STRING;
}
\'[^']*['] {
        yylval.sval = yytext + 1;
        if (yylval.sval[yyleng - 2] != '\'')
                fprintf(stderr, "single quoted string not closed\n");
        else
                yylval.sval[yyleng-2] = 0;
        return STRING;
}
[a-zA-Z0-9\.\-/'"]+		{ yylval.sval = yytext; return STRING; }
\n                              { ++lineno; /* ignore newline */ }
[ \t]+                          /* ignore whitespace */;
\#[^\n]*			return COMMENT;
%%
