//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/storagecache/armstoragecache/v3"
	"net/http"
	"regexp"
)

// UsageModelsServer is a fake server for instances of the armstoragecache.UsageModelsClient type.
type UsageModelsServer struct {
	// NewListPager is the fake for method UsageModelsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armstoragecache.UsageModelsClientListOptions) (resp azfake.PagerResponder[armstoragecache.UsageModelsClientListResponse])
}

// NewUsageModelsServerTransport creates a new instance of UsageModelsServerTransport with the provided implementation.
// The returned UsageModelsServerTransport instance is connected to an instance of armstoragecache.UsageModelsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewUsageModelsServerTransport(srv *UsageModelsServer) *UsageModelsServerTransport {
	return &UsageModelsServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armstoragecache.UsageModelsClientListResponse]](),
	}
}

// UsageModelsServerTransport connects instances of armstoragecache.UsageModelsClient to instances of UsageModelsServer.
// Don't use this type directly, use NewUsageModelsServerTransport instead.
type UsageModelsServerTransport struct {
	srv          *UsageModelsServer
	newListPager *tracker[azfake.PagerResponder[armstoragecache.UsageModelsClientListResponse]]
}

// Do implements the policy.Transporter interface for UsageModelsServerTransport.
func (u *UsageModelsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "UsageModelsClient.NewListPager":
		resp, err = u.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (u *UsageModelsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if u.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := u.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.StorageCache/usageModels`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := u.srv.NewListPager(nil)
		newListPager = &resp
		u.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armstoragecache.UsageModelsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		u.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		u.newListPager.remove(req)
	}
	return resp, nil
}
