//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/sql/armsql/v2"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// UsagesServer is a fake server for instances of the armsql.UsagesClient type.
type UsagesServer struct {
	// NewListByInstancePoolPager is the fake for method UsagesClient.NewListByInstancePoolPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListByInstancePoolPager func(resourceGroupName string, instancePoolName string, options *armsql.UsagesClientListByInstancePoolOptions) (resp azfake.PagerResponder[armsql.UsagesClientListByInstancePoolResponse])
}

// NewUsagesServerTransport creates a new instance of UsagesServerTransport with the provided implementation.
// The returned UsagesServerTransport instance is connected to an instance of armsql.UsagesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewUsagesServerTransport(srv *UsagesServer) *UsagesServerTransport {
	return &UsagesServerTransport{
		srv:                        srv,
		newListByInstancePoolPager: newTracker[azfake.PagerResponder[armsql.UsagesClientListByInstancePoolResponse]](),
	}
}

// UsagesServerTransport connects instances of armsql.UsagesClient to instances of UsagesServer.
// Don't use this type directly, use NewUsagesServerTransport instead.
type UsagesServerTransport struct {
	srv                        *UsagesServer
	newListByInstancePoolPager *tracker[azfake.PagerResponder[armsql.UsagesClientListByInstancePoolResponse]]
}

// Do implements the policy.Transporter interface for UsagesServerTransport.
func (u *UsagesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "UsagesClient.NewListByInstancePoolPager":
		resp, err = u.dispatchNewListByInstancePoolPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (u *UsagesServerTransport) dispatchNewListByInstancePoolPager(req *http.Request) (*http.Response, error) {
	if u.srv.NewListByInstancePoolPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListByInstancePoolPager not implemented")}
	}
	newListByInstancePoolPager := u.newListByInstancePoolPager.get(req)
	if newListByInstancePoolPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Sql/instancePools/(?P<instancePoolName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/usages`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		instancePoolNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("instancePoolName")])
		if err != nil {
			return nil, err
		}
		expandChildrenUnescaped, err := url.QueryUnescape(qp.Get("expandChildren"))
		if err != nil {
			return nil, err
		}
		expandChildrenParam, err := parseOptional(expandChildrenUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		var options *armsql.UsagesClientListByInstancePoolOptions
		if expandChildrenParam != nil {
			options = &armsql.UsagesClientListByInstancePoolOptions{
				ExpandChildren: expandChildrenParam,
			}
		}
		resp := u.srv.NewListByInstancePoolPager(resourceGroupNameParam, instancePoolNameParam, options)
		newListByInstancePoolPager = &resp
		u.newListByInstancePoolPager.add(req, newListByInstancePoolPager)
		server.PagerResponderInjectNextLinks(newListByInstancePoolPager, req, func(page *armsql.UsagesClientListByInstancePoolResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListByInstancePoolPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		u.newListByInstancePoolPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListByInstancePoolPager) {
		u.newListByInstancePoolPager.remove(req)
	}
	return resp, nil
}
