//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/security/armsecurity"
	"net/http"
	"regexp"
)

// SecureScoreControlDefinitionsServer is a fake server for instances of the armsecurity.SecureScoreControlDefinitionsClient type.
type SecureScoreControlDefinitionsServer struct {
	// NewListPager is the fake for method SecureScoreControlDefinitionsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(options *armsecurity.SecureScoreControlDefinitionsClientListOptions) (resp azfake.PagerResponder[armsecurity.SecureScoreControlDefinitionsClientListResponse])

	// NewListBySubscriptionPager is the fake for method SecureScoreControlDefinitionsClient.NewListBySubscriptionPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListBySubscriptionPager func(options *armsecurity.SecureScoreControlDefinitionsClientListBySubscriptionOptions) (resp azfake.PagerResponder[armsecurity.SecureScoreControlDefinitionsClientListBySubscriptionResponse])
}

// NewSecureScoreControlDefinitionsServerTransport creates a new instance of SecureScoreControlDefinitionsServerTransport with the provided implementation.
// The returned SecureScoreControlDefinitionsServerTransport instance is connected to an instance of armsecurity.SecureScoreControlDefinitionsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewSecureScoreControlDefinitionsServerTransport(srv *SecureScoreControlDefinitionsServer) *SecureScoreControlDefinitionsServerTransport {
	return &SecureScoreControlDefinitionsServerTransport{
		srv:                        srv,
		newListPager:               newTracker[azfake.PagerResponder[armsecurity.SecureScoreControlDefinitionsClientListResponse]](),
		newListBySubscriptionPager: newTracker[azfake.PagerResponder[armsecurity.SecureScoreControlDefinitionsClientListBySubscriptionResponse]](),
	}
}

// SecureScoreControlDefinitionsServerTransport connects instances of armsecurity.SecureScoreControlDefinitionsClient to instances of SecureScoreControlDefinitionsServer.
// Don't use this type directly, use NewSecureScoreControlDefinitionsServerTransport instead.
type SecureScoreControlDefinitionsServerTransport struct {
	srv                        *SecureScoreControlDefinitionsServer
	newListPager               *tracker[azfake.PagerResponder[armsecurity.SecureScoreControlDefinitionsClientListResponse]]
	newListBySubscriptionPager *tracker[azfake.PagerResponder[armsecurity.SecureScoreControlDefinitionsClientListBySubscriptionResponse]]
}

// Do implements the policy.Transporter interface for SecureScoreControlDefinitionsServerTransport.
func (s *SecureScoreControlDefinitionsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "SecureScoreControlDefinitionsClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	case "SecureScoreControlDefinitionsClient.NewListBySubscriptionPager":
		resp, err = s.dispatchNewListBySubscriptionPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *SecureScoreControlDefinitionsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		resp := s.srv.NewListPager(nil)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armsecurity.SecureScoreControlDefinitionsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}

func (s *SecureScoreControlDefinitionsServerTransport) dispatchNewListBySubscriptionPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListBySubscriptionPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListBySubscriptionPager not implemented")}
	}
	newListBySubscriptionPager := s.newListBySubscriptionPager.get(req)
	if newListBySubscriptionPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Security/secureScoreControlDefinitions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resp := s.srv.NewListBySubscriptionPager(nil)
		newListBySubscriptionPager = &resp
		s.newListBySubscriptionPager.add(req, newListBySubscriptionPager)
		server.PagerResponderInjectNextLinks(newListBySubscriptionPager, req, func(page *armsecurity.SecureScoreControlDefinitionsClientListBySubscriptionResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListBySubscriptionPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListBySubscriptionPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListBySubscriptionPager) {
		s.newListBySubscriptionPager.remove(req)
	}
	return resp, nil
}
