//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armreservations

import (
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
)

// ClientFactory is a client factory used to create any client in this module.
// Don't use this type directly, use NewClientFactory instead.
type ClientFactory struct {
	credential azcore.TokenCredential
	options    *arm.ClientOptions
}

// NewClientFactory creates a new instance of ClientFactory with the specified values.
// The parameter values will be propagated to any client created from this factory.
//   - credential - used to authorize requests. Usually a credential from azidentity.
//   - options - pass nil to accept the default values.
func NewClientFactory(credential azcore.TokenCredential, options *arm.ClientOptions) (*ClientFactory, error) {
	_, err := arm.NewClient(moduleName, moduleVersion, credential, options)
	if err != nil {
		return nil, err
	}
	return &ClientFactory{
		credential: credential,
		options:    options.Clone(),
	}, nil
}

// NewAzureReservationAPIClient creates a new instance of AzureReservationAPIClient.
func (c *ClientFactory) NewAzureReservationAPIClient() *AzureReservationAPIClient {
	subClient, _ := NewAzureReservationAPIClient(c.credential, c.options)
	return subClient
}

// NewCalculateExchangeClient creates a new instance of CalculateExchangeClient.
func (c *ClientFactory) NewCalculateExchangeClient() *CalculateExchangeClient {
	subClient, _ := NewCalculateExchangeClient(c.credential, c.options)
	return subClient
}

// NewCalculateRefundClient creates a new instance of CalculateRefundClient.
func (c *ClientFactory) NewCalculateRefundClient() *CalculateRefundClient {
	subClient, _ := NewCalculateRefundClient(c.credential, c.options)
	return subClient
}

// NewExchangeClient creates a new instance of ExchangeClient.
func (c *ClientFactory) NewExchangeClient() *ExchangeClient {
	subClient, _ := NewExchangeClient(c.credential, c.options)
	return subClient
}

// NewOperationClient creates a new instance of OperationClient.
func (c *ClientFactory) NewOperationClient() *OperationClient {
	subClient, _ := NewOperationClient(c.credential, c.options)
	return subClient
}

// NewQuotaClient creates a new instance of QuotaClient.
func (c *ClientFactory) NewQuotaClient() *QuotaClient {
	subClient, _ := NewQuotaClient(c.credential, c.options)
	return subClient
}

// NewQuotaRequestStatusClient creates a new instance of QuotaRequestStatusClient.
func (c *ClientFactory) NewQuotaRequestStatusClient() *QuotaRequestStatusClient {
	subClient, _ := NewQuotaRequestStatusClient(c.credential, c.options)
	return subClient
}

// NewReservationClient creates a new instance of ReservationClient.
func (c *ClientFactory) NewReservationClient() *ReservationClient {
	subClient, _ := NewReservationClient(c.credential, c.options)
	return subClient
}

// NewReservationOrderClient creates a new instance of ReservationOrderClient.
func (c *ClientFactory) NewReservationOrderClient() *ReservationOrderClient {
	subClient, _ := NewReservationOrderClient(c.credential, c.options)
	return subClient
}

// NewReturnClient creates a new instance of ReturnClient.
func (c *ClientFactory) NewReturnClient() *ReturnClient {
	subClient, _ := NewReturnClient(c.credential, c.options)
	return subClient
}
