//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"context"
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/chaos/armchaos"
	"net/http"
	"net/url"
	"regexp"
	"strconv"
)

// ExperimentsServer is a fake server for instances of the armchaos.ExperimentsClient type.
type ExperimentsServer struct {
	// BeginCancel is the fake for method ExperimentsClient.BeginCancel
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginCancel func(ctx context.Context, resourceGroupName string, experimentName string, options *armchaos.ExperimentsClientBeginCancelOptions) (resp azfake.PollerResponder[armchaos.ExperimentsClientCancelResponse], errResp azfake.ErrorResponder)

	// BeginCreateOrUpdate is the fake for method ExperimentsClient.BeginCreateOrUpdate
	// HTTP status codes to indicate success: http.StatusOK, http.StatusCreated
	BeginCreateOrUpdate func(ctx context.Context, resourceGroupName string, experimentName string, experiment armchaos.Experiment, options *armchaos.ExperimentsClientBeginCreateOrUpdateOptions) (resp azfake.PollerResponder[armchaos.ExperimentsClientCreateOrUpdateResponse], errResp azfake.ErrorResponder)

	// BeginDelete is the fake for method ExperimentsClient.BeginDelete
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginDelete func(ctx context.Context, resourceGroupName string, experimentName string, options *armchaos.ExperimentsClientBeginDeleteOptions) (resp azfake.PollerResponder[armchaos.ExperimentsClientDeleteResponse], errResp azfake.ErrorResponder)

	// ExecutionDetails is the fake for method ExperimentsClient.ExecutionDetails
	// HTTP status codes to indicate success: http.StatusOK
	ExecutionDetails func(ctx context.Context, resourceGroupName string, experimentName string, executionID string, options *armchaos.ExperimentsClientExecutionDetailsOptions) (resp azfake.Responder[armchaos.ExperimentsClientExecutionDetailsResponse], errResp azfake.ErrorResponder)

	// Get is the fake for method ExperimentsClient.Get
	// HTTP status codes to indicate success: http.StatusOK
	Get func(ctx context.Context, resourceGroupName string, experimentName string, options *armchaos.ExperimentsClientGetOptions) (resp azfake.Responder[armchaos.ExperimentsClientGetResponse], errResp azfake.ErrorResponder)

	// GetExecution is the fake for method ExperimentsClient.GetExecution
	// HTTP status codes to indicate success: http.StatusOK
	GetExecution func(ctx context.Context, resourceGroupName string, experimentName string, executionID string, options *armchaos.ExperimentsClientGetExecutionOptions) (resp azfake.Responder[armchaos.ExperimentsClientGetExecutionResponse], errResp azfake.ErrorResponder)

	// NewListPager is the fake for method ExperimentsClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(resourceGroupName string, options *armchaos.ExperimentsClientListOptions) (resp azfake.PagerResponder[armchaos.ExperimentsClientListResponse])

	// NewListAllPager is the fake for method ExperimentsClient.NewListAllPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAllPager func(options *armchaos.ExperimentsClientListAllOptions) (resp azfake.PagerResponder[armchaos.ExperimentsClientListAllResponse])

	// NewListAllExecutionsPager is the fake for method ExperimentsClient.NewListAllExecutionsPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListAllExecutionsPager func(resourceGroupName string, experimentName string, options *armchaos.ExperimentsClientListAllExecutionsOptions) (resp azfake.PagerResponder[armchaos.ExperimentsClientListAllExecutionsResponse])

	// BeginStart is the fake for method ExperimentsClient.BeginStart
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginStart func(ctx context.Context, resourceGroupName string, experimentName string, options *armchaos.ExperimentsClientBeginStartOptions) (resp azfake.PollerResponder[armchaos.ExperimentsClientStartResponse], errResp azfake.ErrorResponder)

	// BeginUpdate is the fake for method ExperimentsClient.BeginUpdate
	// HTTP status codes to indicate success: http.StatusAccepted
	BeginUpdate func(ctx context.Context, resourceGroupName string, experimentName string, experiment armchaos.ExperimentUpdate, options *armchaos.ExperimentsClientBeginUpdateOptions) (resp azfake.PollerResponder[armchaos.ExperimentsClientUpdateResponse], errResp azfake.ErrorResponder)
}

// NewExperimentsServerTransport creates a new instance of ExperimentsServerTransport with the provided implementation.
// The returned ExperimentsServerTransport instance is connected to an instance of armchaos.ExperimentsClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewExperimentsServerTransport(srv *ExperimentsServer) *ExperimentsServerTransport {
	return &ExperimentsServerTransport{
		srv:                       srv,
		beginCancel:               newTracker[azfake.PollerResponder[armchaos.ExperimentsClientCancelResponse]](),
		beginCreateOrUpdate:       newTracker[azfake.PollerResponder[armchaos.ExperimentsClientCreateOrUpdateResponse]](),
		beginDelete:               newTracker[azfake.PollerResponder[armchaos.ExperimentsClientDeleteResponse]](),
		newListPager:              newTracker[azfake.PagerResponder[armchaos.ExperimentsClientListResponse]](),
		newListAllPager:           newTracker[azfake.PagerResponder[armchaos.ExperimentsClientListAllResponse]](),
		newListAllExecutionsPager: newTracker[azfake.PagerResponder[armchaos.ExperimentsClientListAllExecutionsResponse]](),
		beginStart:                newTracker[azfake.PollerResponder[armchaos.ExperimentsClientStartResponse]](),
		beginUpdate:               newTracker[azfake.PollerResponder[armchaos.ExperimentsClientUpdateResponse]](),
	}
}

// ExperimentsServerTransport connects instances of armchaos.ExperimentsClient to instances of ExperimentsServer.
// Don't use this type directly, use NewExperimentsServerTransport instead.
type ExperimentsServerTransport struct {
	srv                       *ExperimentsServer
	beginCancel               *tracker[azfake.PollerResponder[armchaos.ExperimentsClientCancelResponse]]
	beginCreateOrUpdate       *tracker[azfake.PollerResponder[armchaos.ExperimentsClientCreateOrUpdateResponse]]
	beginDelete               *tracker[azfake.PollerResponder[armchaos.ExperimentsClientDeleteResponse]]
	newListPager              *tracker[azfake.PagerResponder[armchaos.ExperimentsClientListResponse]]
	newListAllPager           *tracker[azfake.PagerResponder[armchaos.ExperimentsClientListAllResponse]]
	newListAllExecutionsPager *tracker[azfake.PagerResponder[armchaos.ExperimentsClientListAllExecutionsResponse]]
	beginStart                *tracker[azfake.PollerResponder[armchaos.ExperimentsClientStartResponse]]
	beginUpdate               *tracker[azfake.PollerResponder[armchaos.ExperimentsClientUpdateResponse]]
}

// Do implements the policy.Transporter interface for ExperimentsServerTransport.
func (e *ExperimentsServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ExperimentsClient.BeginCancel":
		resp, err = e.dispatchBeginCancel(req)
	case "ExperimentsClient.BeginCreateOrUpdate":
		resp, err = e.dispatchBeginCreateOrUpdate(req)
	case "ExperimentsClient.BeginDelete":
		resp, err = e.dispatchBeginDelete(req)
	case "ExperimentsClient.ExecutionDetails":
		resp, err = e.dispatchExecutionDetails(req)
	case "ExperimentsClient.Get":
		resp, err = e.dispatchGet(req)
	case "ExperimentsClient.GetExecution":
		resp, err = e.dispatchGetExecution(req)
	case "ExperimentsClient.NewListPager":
		resp, err = e.dispatchNewListPager(req)
	case "ExperimentsClient.NewListAllPager":
		resp, err = e.dispatchNewListAllPager(req)
	case "ExperimentsClient.NewListAllExecutionsPager":
		resp, err = e.dispatchNewListAllExecutionsPager(req)
	case "ExperimentsClient.BeginStart":
		resp, err = e.dispatchBeginStart(req)
	case "ExperimentsClient.BeginUpdate":
		resp, err = e.dispatchBeginUpdate(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (e *ExperimentsServerTransport) dispatchBeginCancel(req *http.Request) (*http.Response, error) {
	if e.srv.BeginCancel == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCancel not implemented")}
	}
	beginCancel := e.beginCancel.get(req)
	if beginCancel == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Chaos/experiments/(?P<experimentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/cancel`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		experimentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("experimentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginCancel(req.Context(), resourceGroupNameParam, experimentNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCancel = &respr
		e.beginCancel.add(req, beginCancel)
	}

	resp, err := server.PollerResponderNext(beginCancel, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		e.beginCancel.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCancel) {
		e.beginCancel.remove(req)
	}

	return resp, nil
}

func (e *ExperimentsServerTransport) dispatchBeginCreateOrUpdate(req *http.Request) (*http.Response, error) {
	if e.srv.BeginCreateOrUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginCreateOrUpdate not implemented")}
	}
	beginCreateOrUpdate := e.beginCreateOrUpdate.get(req)
	if beginCreateOrUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Chaos/experiments/(?P<experimentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armchaos.Experiment](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		experimentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("experimentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginCreateOrUpdate(req.Context(), resourceGroupNameParam, experimentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginCreateOrUpdate = &respr
		e.beginCreateOrUpdate.add(req, beginCreateOrUpdate)
	}

	resp, err := server.PollerResponderNext(beginCreateOrUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusOK, http.StatusCreated}, resp.StatusCode) {
		e.beginCreateOrUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK, http.StatusCreated", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginCreateOrUpdate) {
		e.beginCreateOrUpdate.remove(req)
	}

	return resp, nil
}

func (e *ExperimentsServerTransport) dispatchBeginDelete(req *http.Request) (*http.Response, error) {
	if e.srv.BeginDelete == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginDelete not implemented")}
	}
	beginDelete := e.beginDelete.get(req)
	if beginDelete == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Chaos/experiments/(?P<experimentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		experimentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("experimentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginDelete(req.Context(), resourceGroupNameParam, experimentNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginDelete = &respr
		e.beginDelete.add(req, beginDelete)
	}

	resp, err := server.PollerResponderNext(beginDelete, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		e.beginDelete.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginDelete) {
		e.beginDelete.remove(req)
	}

	return resp, nil
}

func (e *ExperimentsServerTransport) dispatchExecutionDetails(req *http.Request) (*http.Response, error) {
	if e.srv.ExecutionDetails == nil {
		return nil, &nonRetriableError{errors.New("fake for method ExecutionDetails not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Chaos/experiments/(?P<experimentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/executions/(?P<executionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/getExecutionDetails`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	experimentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("experimentName")])
	if err != nil {
		return nil, err
	}
	executionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("executionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.ExecutionDetails(req.Context(), resourceGroupNameParam, experimentNameParam, executionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ExperimentExecutionDetails, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *ExperimentsServerTransport) dispatchGet(req *http.Request) (*http.Response, error) {
	if e.srv.Get == nil {
		return nil, &nonRetriableError{errors.New("fake for method Get not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Chaos/experiments/(?P<experimentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 3 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	experimentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("experimentName")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.Get(req.Context(), resourceGroupNameParam, experimentNameParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).Experiment, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *ExperimentsServerTransport) dispatchGetExecution(req *http.Request) (*http.Response, error) {
	if e.srv.GetExecution == nil {
		return nil, &nonRetriableError{errors.New("fake for method GetExecution not implemented")}
	}
	const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Chaos/experiments/(?P<experimentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/executions/(?P<executionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
	regex := regexp.MustCompile(regexStr)
	matches := regex.FindStringSubmatch(req.URL.EscapedPath())
	if matches == nil || len(matches) < 4 {
		return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
	}
	resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
	if err != nil {
		return nil, err
	}
	experimentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("experimentName")])
	if err != nil {
		return nil, err
	}
	executionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("executionId")])
	if err != nil {
		return nil, err
	}
	respr, errRespr := e.srv.GetExecution(req.Context(), resourceGroupNameParam, experimentNameParam, executionIDParam, nil)
	if respErr := server.GetError(errRespr, req); respErr != nil {
		return nil, respErr
	}
	respContent := server.GetResponseContent(respr)
	if !contains([]int{http.StatusOK}, respContent.HTTPStatus) {
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", respContent.HTTPStatus)}
	}
	resp, err := server.MarshalResponseAsJSON(respContent, server.GetResponse(respr).ExperimentExecution, req)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (e *ExperimentsServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := e.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Chaos/experiments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		runningUnescaped, err := url.QueryUnescape(qp.Get("running"))
		if err != nil {
			return nil, err
		}
		runningParam, err := parseOptional(runningUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		continuationTokenUnescaped, err := url.QueryUnescape(qp.Get("continuationToken"))
		if err != nil {
			return nil, err
		}
		continuationTokenParam := getOptional(continuationTokenUnescaped)
		var options *armchaos.ExperimentsClientListOptions
		if runningParam != nil || continuationTokenParam != nil {
			options = &armchaos.ExperimentsClientListOptions{
				Running:           runningParam,
				ContinuationToken: continuationTokenParam,
			}
		}
		resp := e.srv.NewListPager(resourceGroupNameParam, options)
		newListPager = &resp
		e.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armchaos.ExperimentsClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		e.newListPager.remove(req)
	}
	return resp, nil
}

func (e *ExperimentsServerTransport) dispatchNewListAllPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListAllPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAllPager not implemented")}
	}
	newListAllPager := e.newListAllPager.get(req)
	if newListAllPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Chaos/experiments`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 1 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		qp := req.URL.Query()
		runningUnescaped, err := url.QueryUnescape(qp.Get("running"))
		if err != nil {
			return nil, err
		}
		runningParam, err := parseOptional(runningUnescaped, strconv.ParseBool)
		if err != nil {
			return nil, err
		}
		continuationTokenUnescaped, err := url.QueryUnescape(qp.Get("continuationToken"))
		if err != nil {
			return nil, err
		}
		continuationTokenParam := getOptional(continuationTokenUnescaped)
		var options *armchaos.ExperimentsClientListAllOptions
		if runningParam != nil || continuationTokenParam != nil {
			options = &armchaos.ExperimentsClientListAllOptions{
				Running:           runningParam,
				ContinuationToken: continuationTokenParam,
			}
		}
		resp := e.srv.NewListAllPager(options)
		newListAllPager = &resp
		e.newListAllPager.add(req, newListAllPager)
		server.PagerResponderInjectNextLinks(newListAllPager, req, func(page *armchaos.ExperimentsClientListAllResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAllPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListAllPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAllPager) {
		e.newListAllPager.remove(req)
	}
	return resp, nil
}

func (e *ExperimentsServerTransport) dispatchNewListAllExecutionsPager(req *http.Request) (*http.Response, error) {
	if e.srv.NewListAllExecutionsPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListAllExecutionsPager not implemented")}
	}
	newListAllExecutionsPager := e.newListAllExecutionsPager.get(req)
	if newListAllExecutionsPager == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Chaos/experiments/(?P<experimentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/executions`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		experimentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("experimentName")])
		if err != nil {
			return nil, err
		}
		resp := e.srv.NewListAllExecutionsPager(resourceGroupNameParam, experimentNameParam, nil)
		newListAllExecutionsPager = &resp
		e.newListAllExecutionsPager.add(req, newListAllExecutionsPager)
		server.PagerResponderInjectNextLinks(newListAllExecutionsPager, req, func(page *armchaos.ExperimentsClientListAllExecutionsResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListAllExecutionsPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		e.newListAllExecutionsPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListAllExecutionsPager) {
		e.newListAllExecutionsPager.remove(req)
	}
	return resp, nil
}

func (e *ExperimentsServerTransport) dispatchBeginStart(req *http.Request) (*http.Response, error) {
	if e.srv.BeginStart == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginStart not implemented")}
	}
	beginStart := e.beginStart.get(req)
	if beginStart == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Chaos/experiments/(?P<experimentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/start`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		experimentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("experimentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginStart(req.Context(), resourceGroupNameParam, experimentNameParam, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginStart = &respr
		e.beginStart.add(req, beginStart)
	}

	resp, err := server.PollerResponderNext(beginStart, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		e.beginStart.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginStart) {
		e.beginStart.remove(req)
	}

	return resp, nil
}

func (e *ExperimentsServerTransport) dispatchBeginUpdate(req *http.Request) (*http.Response, error) {
	if e.srv.BeginUpdate == nil {
		return nil, &nonRetriableError{errors.New("fake for method BeginUpdate not implemented")}
	}
	beginUpdate := e.beginUpdate.get(req)
	if beginUpdate == nil {
		const regexStr = `/subscriptions/(?P<subscriptionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/resourceGroups/(?P<resourceGroupName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Chaos/experiments/(?P<experimentName>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 3 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		body, err := server.UnmarshalRequestAsJSON[armchaos.ExperimentUpdate](req)
		if err != nil {
			return nil, err
		}
		resourceGroupNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("resourceGroupName")])
		if err != nil {
			return nil, err
		}
		experimentNameParam, err := url.PathUnescape(matches[regex.SubexpIndex("experimentName")])
		if err != nil {
			return nil, err
		}
		respr, errRespr := e.srv.BeginUpdate(req.Context(), resourceGroupNameParam, experimentNameParam, body, nil)
		if respErr := server.GetError(errRespr, req); respErr != nil {
			return nil, respErr
		}
		beginUpdate = &respr
		e.beginUpdate.add(req, beginUpdate)
	}

	resp, err := server.PollerResponderNext(beginUpdate, req)
	if err != nil {
		return nil, err
	}

	if !contains([]int{http.StatusAccepted}, resp.StatusCode) {
		e.beginUpdate.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusAccepted", resp.StatusCode)}
	}
	if !server.PollerResponderMore(beginUpdate) {
		e.beginUpdate.remove(req)
	}

	return resp, nil
}
