//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package fake

import (
	"errors"
	"fmt"
	azfake "github.com/Azure/azure-sdk-for-go/sdk/azcore/fake"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/fake/server"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/to"
	"github.com/Azure/azure-sdk-for-go/sdk/resourcemanager/authorization/armauthorization/v3"
	"net/http"
	"net/url"
	"regexp"
)

// ScopeAccessReviewHistoryDefinitionInstancesServer is a fake server for instances of the armauthorization.ScopeAccessReviewHistoryDefinitionInstancesClient type.
type ScopeAccessReviewHistoryDefinitionInstancesServer struct {
	// NewListPager is the fake for method ScopeAccessReviewHistoryDefinitionInstancesClient.NewListPager
	// HTTP status codes to indicate success: http.StatusOK
	NewListPager func(scope string, historyDefinitionID string, options *armauthorization.ScopeAccessReviewHistoryDefinitionInstancesClientListOptions) (resp azfake.PagerResponder[armauthorization.ScopeAccessReviewHistoryDefinitionInstancesClientListResponse])
}

// NewScopeAccessReviewHistoryDefinitionInstancesServerTransport creates a new instance of ScopeAccessReviewHistoryDefinitionInstancesServerTransport with the provided implementation.
// The returned ScopeAccessReviewHistoryDefinitionInstancesServerTransport instance is connected to an instance of armauthorization.ScopeAccessReviewHistoryDefinitionInstancesClient via the
// azcore.ClientOptions.Transporter field in the client's constructor parameters.
func NewScopeAccessReviewHistoryDefinitionInstancesServerTransport(srv *ScopeAccessReviewHistoryDefinitionInstancesServer) *ScopeAccessReviewHistoryDefinitionInstancesServerTransport {
	return &ScopeAccessReviewHistoryDefinitionInstancesServerTransport{
		srv:          srv,
		newListPager: newTracker[azfake.PagerResponder[armauthorization.ScopeAccessReviewHistoryDefinitionInstancesClientListResponse]](),
	}
}

// ScopeAccessReviewHistoryDefinitionInstancesServerTransport connects instances of armauthorization.ScopeAccessReviewHistoryDefinitionInstancesClient to instances of ScopeAccessReviewHistoryDefinitionInstancesServer.
// Don't use this type directly, use NewScopeAccessReviewHistoryDefinitionInstancesServerTransport instead.
type ScopeAccessReviewHistoryDefinitionInstancesServerTransport struct {
	srv          *ScopeAccessReviewHistoryDefinitionInstancesServer
	newListPager *tracker[azfake.PagerResponder[armauthorization.ScopeAccessReviewHistoryDefinitionInstancesClientListResponse]]
}

// Do implements the policy.Transporter interface for ScopeAccessReviewHistoryDefinitionInstancesServerTransport.
func (s *ScopeAccessReviewHistoryDefinitionInstancesServerTransport) Do(req *http.Request) (*http.Response, error) {
	rawMethod := req.Context().Value(runtime.CtxAPINameKey{})
	method, ok := rawMethod.(string)
	if !ok {
		return nil, nonRetriableError{errors.New("unable to dispatch request, missing value for CtxAPINameKey")}
	}

	var resp *http.Response
	var err error

	switch method {
	case "ScopeAccessReviewHistoryDefinitionInstancesClient.NewListPager":
		resp, err = s.dispatchNewListPager(req)
	default:
		err = fmt.Errorf("unhandled API %s", method)
	}

	if err != nil {
		return nil, err
	}

	return resp, nil
}

func (s *ScopeAccessReviewHistoryDefinitionInstancesServerTransport) dispatchNewListPager(req *http.Request) (*http.Response, error) {
	if s.srv.NewListPager == nil {
		return nil, &nonRetriableError{errors.New("fake for method NewListPager not implemented")}
	}
	newListPager := s.newListPager.get(req)
	if newListPager == nil {
		const regexStr = `/(?P<scope>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/providers/Microsoft\.Authorization/accessReviewHistoryDefinitions/(?P<historyDefinitionId>[!#&$-;=?-\[\]_a-zA-Z0-9~%@]+)/instances`
		regex := regexp.MustCompile(regexStr)
		matches := regex.FindStringSubmatch(req.URL.EscapedPath())
		if matches == nil || len(matches) < 2 {
			return nil, fmt.Errorf("failed to parse path %s", req.URL.Path)
		}
		scopeParam, err := url.PathUnescape(matches[regex.SubexpIndex("scope")])
		if err != nil {
			return nil, err
		}
		historyDefinitionIDParam, err := url.PathUnescape(matches[regex.SubexpIndex("historyDefinitionId")])
		if err != nil {
			return nil, err
		}
		resp := s.srv.NewListPager(scopeParam, historyDefinitionIDParam, nil)
		newListPager = &resp
		s.newListPager.add(req, newListPager)
		server.PagerResponderInjectNextLinks(newListPager, req, func(page *armauthorization.ScopeAccessReviewHistoryDefinitionInstancesClientListResponse, createLink func() string) {
			page.NextLink = to.Ptr(createLink())
		})
	}
	resp, err := server.PagerResponderNext(newListPager, req)
	if err != nil {
		return nil, err
	}
	if !contains([]int{http.StatusOK}, resp.StatusCode) {
		s.newListPager.remove(req)
		return nil, &nonRetriableError{fmt.Errorf("unexpected status code %d. acceptable values are http.StatusOK", resp.StatusCode)}
	}
	if !server.PagerResponderMore(newListPager) {
		s.newListPager.remove(req)
	}
	return resp, nil
}
