/*
 * (C) Copyright 1996- ECMWF.
 *
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 *
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation nor
 * does it submit to any jurisdiction.
 */


#pragma once

#include <memory>
#include <vector>


namespace eckit {
namespace spec {
class Spec;
}
class PathName;
}  // namespace eckit


namespace eckit::geo::share {


class Grid final {
public:

    static const Grid& instance();

private:

    // -- Constructors

    explicit Grid(const std::vector<PathName>&);

    // -- Members

    std::unique_ptr<spec::Spec> spec_;

    // -- Methods

    void load(const PathName&);
};


}  // namespace eckit::geo::share
